<?php $__env->startSection('content'); ?>
    <section class="pb-60 pt-60">
        <div class="container">
            <div class="row gy-4 mb-4">
                <div class="col-md-5">
                    <div class="card h-100">
                        <div class="card-body">
                            <div class="d-flex flex-wrap justify-content-between align-items-center">
                                <div>
                                    <p class="mb-2 fw-bold"><?php echo app('translator')->get('Total Invest'); ?></p>
                                    <h4 class="text--base"><sup class="top-0 fw-light me-1"><?php echo e(gs('cur_sym')); ?></sup><?php echo e(showAmount(auth()->user()->invests->sum('amount'), currencyFormat:false)); ?></h4>
                                </div>
                                <div>
                                    <p class="mb-2 fw-bold"><?php echo app('translator')->get('Total Profit'); ?></p>
                                    <h4 class="text--base"><sup class="top-0 fw-light me-1"><?php echo e(gs('cur_sym')); ?></sup><?php echo e(showAmount(auth()->user()->transactions()->where('remark', 'interest')->sum('amount'), currencyFormat:false)); ?></h4>
                                </div>
                            </div>
                            <div class="d-flex flex-wrap justify-content-between mt-3 mt-sm-4 gap-2">
                                <a href="<?php echo e(route('plan')); ?>" class="btn btn--sm btn--base"><?php echo app('translator')->get('Invest Now'); ?> <i class="las la-arrow-right fs--12px ms-1"></i></a>
                                <a href="<?php echo e(route('user.withdraw')); ?>" class="btn btn--sm btn--base"><?php echo app('translator')->get('Withdraw Now'); ?> <i class="las la-arrow-right fs--12px ms-1"></i></a>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-7">
                    <div class="card h-100">
                        <div class="card-body">
                            <?php if($investChart->count()): ?>
                                <div class="invest-statistics d-flex flex-wrap justify-content-between align-items-center">
                                    <div class="flex-shrink-0">
                                        <?php $__currentLoopData = $investChart; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $chart): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <p class="my-2"><i class="fas fa-plane planPoint me-2"></i><?php echo e(showAmount(($chart->investAmount / $investChart->sum('investAmount')) * 100, currencyFormat:false)); ?>% - <?php echo e(__($chart->plan->name)); ?></p>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                    <div class="invest-statistics__chart">
                                        <canvas height="150" id="chartjs-pie-chart" style="width: 150px;"></canvas>
                                    </div>
                                </div>
                            <?php else: ?>
                                <h3 class="text-center"><?php echo app('translator')->get('No Investment Found Yet'); ?></h3>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row justify-content-center mt-2">
                <div class="col-md-12">
                    <div class="text-end mb-3">
                        <a href="<?php echo e(route('user.invest.log')); ?>" class="btn btn--base">
                            <?php echo app('translator')->get('View All'); ?>
                        </a>
                    </div>
                </div>
                <?php echo $__env->make($activeTemplate.'partials.invest_history',['invests'=>$invests], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>


<?php $__env->startPush('script'); ?>
    <script src="<?php echo e(asset('assets/global/js/chart.js.2.8.0.js')); ?>"></script>

    <script>
        /* -- Chartjs - Pie Chart -- */
        var pieChartID = document.getElementById("chartjs-pie-chart").getContext('2d');
        var pieChart = new Chart(pieChartID, {
            type: 'pie',
            data: {
                datasets: [{
                    data: [
                        <?php $__currentLoopData = $investChart; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $chart): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php echo e($chart->investAmount); ?>,
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    ],
                    borderColor: 'transparent',
                    backgroundColor: planColors(),
                    label: 'Dataset 1'
                }],
                labels: [
                    <?php $__currentLoopData = $investChart; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $chart): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        '<?php echo e($chart->plan->name); ?>',
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                ]
            },
            options: {
                responsive: true,
                legend: {
                    display: false
                }
            }
        });

        var planPoints = $('.planPoint');
        planPoints.each(function(key, planPoint) {
            var planPoint = $(planPoint)
            planPoint.css('color', planColors()[key])
        })

        function planColors() {
            return [
                '#ff7675',
                '#6c5ce7',
                '#ffa62b',
                '#ffeaa7',
                '#D980FA',
                '#fccbcb',
                '#45aaf2',
                '#05dfd7',
                '#FF00F6',
                '#1e90ff',
                '#2ed573',
                '#eccc68',
                '#ff5200',
                '#cd84f1',
                '#7efff5',
                '#7158e2',
                '#fff200',
                '#ff9ff3',
                '#08ffc8',
                '#3742fa',
                '#1089ff',
                '#70FF61',
                '#bf9fee',
                '#574b90'
            ]
        }
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/qazilzmb/xmtrade.site/core/resources/views/templates/bit_gold/user/invest_statistics.blade.php ENDPATH**/ ?>