<script>
    "use strict"

    function createCountDown(elementId, sec) {
        var tms = sec;
        var x = setInterval(function() {
            var distance = tms * 1000;
            var days = Math.floor(distance / (1000 * 60 * 60 * 24));
            var hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
            var minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
            var seconds = Math.floor((distance % (1000 * 60)) / 1000);
            document.getElementById(elementId).innerHTML = days + "d: " + hours + "h " + minutes + "m " + seconds + "s ";
            if (distance < 0) {
                clearInterval(x);
                document.getElementById(elementId).innerHTML = "COMPLETE";
            }
            tms--;
        }, 1000);
    }
</script>

<div class="col-md-12">
    <div class="table-responsive--md">
        <table class="table">
            <thead>
                <tr>
                    <th><?php echo app('translator')->get('Plan'); ?></th>
                    <th><?php echo app('translator')->get('Return'); ?></th>
                    <th><?php echo app('translator')->get('Received'); ?></th>
                    <th><?php echo app('translator')->get('Next payment'); ?></th>
                    <th><?php echo app('translator')->get('Action'); ?></th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $invests; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invest): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td><?php echo e(__($invest->plan->name)); ?> <br> <?php echo e(showAmount($invest->amount)); ?> </td>
                        <td>
                            <?php echo e(showAmount($invest->interest)); ?> <?php echo app('translator')->get('every'); ?> <?php echo e($invest->time_name); ?>

                            <br>
                            <?php echo app('translator')->get('for'); ?>
                            <?php if($invest->period == '-1'): ?>
                                <?php echo app('translator')->get('Lifetime'); ?>
                            <?php else: ?>
                                <?php echo e($invest->period); ?>

                                <?php echo e($invest->time_name); ?>

                            <?php endif; ?>
                            <?php if($invest->capital_status == '1'): ?>
                                + <?php echo app('translator')->get('Capital'); ?>
                            <?php endif; ?>
                        </td>

                        <td>
                            <?php if($invest->compound_times): ?>
                                <?php echo e($invest->return_rec_time); ?> <?php echo app('translator')->get('times'); ?> | <?php echo e(showAmount($invest->paid)); ?>

                            <?php else: ?>
                                <?php echo e($invest->return_rec_time); ?>x<?php echo e(showAmount($invest->interest)); ?> = <?php echo e(showAmount($invest->paid)); ?>

                            <?php endif; ?>
                        </td>

                        <td scope="row" class="font-weight-bold">
                            <?php if($invest->status == 1): ?>
                                <p id="counter<?php echo e($invest->id); ?>" class="demo countdown timess2 "></p>

                                <?php
                                    if ($invest->last_time) {
                                        $start = $invest->last_time;
                                    } else {
                                        $start = $invest->created_at;
                                    }
                                ?>
                                <div class="progress">
                                    <div class="progress-bar progress-bar-striped bg-success" role="progressbar" style="width: <?php echo e(diffDatePercent($start, $invest->next_time)); ?>%" aria-valuenow="10" aria-valuemin="0" aria-valuemax="100">
                                    </div>
                                </div>
                            <?php elseif($invest->status == 2): ?>
                                <span class="badge badge--danger"><?php echo app('translator')->get('Canceled'); ?></span>
                            <?php else: ?>
                                <span class="badge badge--info"><?php echo app('translator')->get('Completed'); ?></span>
                            <?php endif; ?>
                        </td>

                        <td>
                            <a href="<?php echo e(route('user.invest.details', encrypt($invest->id))); ?>" class="icon-btn base--bg text-white">
                                <i class="fa fa-desktop"></i>
                            </a>
                            <?php if($invest->eligibleCapitalBack()): ?>
                                <button class="icon-btn base--bg text-white manageCapital" data-id="<?php echo e($invest->id); ?>">
                                    <i class="fas fa-hand-holding-usd"></i>
                                </button>
                            <?php endif; ?>
                        </td>

                    </tr>
                
                    <?php if(\Carbon\Carbon::parse($invest->next_time) > now()): ?>
                        <script>
                            createCountDown('counter<?php echo $invest->id; ?>', <?php echo e(abs(\Carbon\Carbon::parse($invest->next_time)->diffInSeconds())); ?>);
                        </script>
                    <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="100%" class="text-center"><?php echo e(__($emptyMessage)); ?></td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<div class="modal fade" id="capitalModal">
    <div class="modal-dialog modal-dialog-centered modal-content-bg">
        <div class="modal-content">
            <div class="modal-header">
                <strong class="modal-title text-white" id="ModalLabel">
                    <?php echo app('translator')->get('Manage Invest Capital'); ?>
                </strong>
                <button type="button" class="close" data-bs-dismiss="modal">
                    <i class="las la-times"></i>
                </button>
            </div>
            <form action="<?php echo e(route('user.invest.capital.manage')); ?>" method="post">
                <?php echo csrf_field(); ?>
                <div class="modal-body">
                    <input type="hidden" name="invest_id">
                    <div class="form-group">
                        <label><?php echo app('translator')->get('Investment Capital'); ?></label>
                        <select name="capital" class="form-control">
                            <option value="reinvest"><?php echo app('translator')->get('Reinvest'); ?></option>
                            <option value="capital_back"><?php echo app('translator')->get('Capital Back'); ?></option>
                        </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn--base btn-md w-100"><?php echo app('translator')->get('Submit'); ?></button>
                </div>
            </form>
        </div>
    </div>
</div>


<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            "use strict";
            $('.manageCapital').on('click', function() {
                let modal = $('#capitalModal');
                modal.find('[name=invest_id]').val($(this).data('id'));
                modal.modal('show');
            });
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/qazilzmb/xmtrade.site/core/resources/views/templates/bit_gold/partials/invest_history.blade.php ENDPATH**/ ?>