

<?php $__env->startSection('content'); ?>
    <section class="pb-60 pt-60">
        <div class="container">
            <?php if($invest->eligibleCapitalBack()): ?>
                <div class="d-flex justify-content-end mb-3">
                    <button class="btn btn--base" data-bs-toggle="modal" data-bs-target="#capitalModal"><?php echo app('translator')->get('Manage Capital'); ?></button>
                </div>
            <?php endif; ?>
            <div class="row gy-3">
                <div class="col-xl-4">
                    <div class="card">
                        <div class="card-header">
                            <h5><?php echo app('translator')->get('Plan Information'); ?></h5>
                        </div>
                        <div class="card-body">
                            <ul class="list-group">
                                <?php
                                    $plan = $invest->plan;
                                ?>
                                <li class="list-group-item d-flex justify-content-between">
                                    <?php echo app('translator')->get('Plan Name'); ?>
                                    <span><?php echo e(__($plan->name)); ?></span>
                                </li>
                                <li class="list-group-item d-flex justify-content-between">
                                    <?php echo app('translator')->get('Investable Amount'); ?>
                                    <span>
                                        <?php if($plan->fixed_amount > 0): ?>
                                            <?php echo e(showAmount($plan->fixed_amount)); ?>

                                        <?php else: ?>
                                            <?php echo e(showAmount($plan->minimum)); ?> - <?php echo e(showAmount($plan->maximum)); ?>

                                        <?php endif; ?>
                                    </span>
                                </li>
                                <li class="list-group-item d-flex justify-content-between">
                                    <?php echo app('translator')->get('Interest'); ?>
                                    <span><?php echo e(showAmount($plan->interest, currencyFormat: false)); ?><?php echo e($plan->interest_type == 1 ? '%' : gs('cur_text')); ?></span>
                                </li>
                                <li class="list-group-item d-flex justify-content-between">
                                    <?php echo app('translator')->get('Compound Interest'); ?>
                                    <span>
                                        <?php if($plan->compound_interest): ?>
                                            <?php echo app('translator')->get('Yes'); ?>
                                        <?php else: ?>
                                            <?php echo app('translator')->get('No'); ?>
                                        <?php endif; ?>
                                    </span>
                                </li>
                                <li class="list-group-item d-flex justify-content-between">
                                    <?php echo app('translator')->get('Hold Capital'); ?>
                                    <span>
                                        <?php if($plan->hold_capital): ?>
                                            <?php echo app('translator')->get('Yes'); ?>
                                        <?php else: ?>
                                            <?php echo app('translator')->get('No'); ?>
                                        <?php endif; ?>
                                    </span>
                                </li>
                                <li class="list-group-item d-flex justify-content-between">
                                    <?php echo app('translator')->get('Repeat Time'); ?>
                                    <span>
                                        <?php if($plan->repeat_time): ?>
                                            <?php echo e($plan->repeat_time); ?> <?php echo app('translator')->get('times'); ?>
                                        <?php else: ?>
                                            <?php echo app('translator')->get('Lifetime'); ?>
                                        <?php endif; ?>
                                    </span>
                                </li>
                                <li class="list-group-item d-flex justify-content-between">
                                    <?php echo app('translator')->get('Status'); ?>
                                    <span>
                                        <?php if($plan->status): ?>
                                            <span class="badge badge--success"><?php echo app('translator')->get('Enable'); ?></span>
                                        <?php else: ?>
                                            <span class="badge badge--warning"><?php echo app('translator')->get('Disable'); ?></span>
                                        <?php endif; ?>
                                    </span>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="col-xl-4 col-md-6">
                    <div class="card">
                        <div class="card-header">
                            <h5><?php echo app('translator')->get('Basic Information'); ?></h5>
                        </div>
                        <div class="card-body">
                            <ul class="list-group">
                                <li class="list-group-item d-flex justify-content-between">
                                    <?php echo app('translator')->get('Initial Invest'); ?>
                                    <span><?php echo e(showAmount($invest->initial_amount)); ?></span>
                                </li>
                                <li class="list-group-item d-flex justify-content-between">
                                    <?php echo app('translator')->get('Current Invest'); ?>
                                    <span><?php echo e(showAmount($invest->amount)); ?></span>
                                </li>
                                <li class="list-group-item d-flex justify-content-between">
                                    <?php echo app('translator')->get('Invested'); ?>
                                    <span><?php echo e(showDateTime($invest->created_at)); ?></span>
                                </li>
                                <li class="list-group-item d-flex justify-content-between">
                                    <?php echo app('translator')->get('Initial Interest'); ?>
                                    <span><?php echo e(showAmount($invest->initial_interest)); ?></span>
                                </li>
                                <li class="list-group-item d-flex justify-content-between">
                                    <?php echo app('translator')->get('Current Interest'); ?>
                                    <span><?php echo e(showAmount($invest->interest)); ?></span>
                                </li>
                                <li class="list-group-item d-flex justify-content-between">
                                    <?php echo app('translator')->get('Interest Interval'); ?>
                                    <span><?php echo app('translator')->get('Every '); ?> <?php echo e($invest->time_name); ?></span>
                                </li>
                                <li class="list-group-item d-flex justify-content-between">
                                    <?php echo app('translator')->get('Status'); ?>
                                    <span>
                                        <?php if($invest->status == 1): ?>
                                            <span class="badge badge--success"><?php echo app('translator')->get('Running'); ?></span>
                                        <?php elseif($invest->status == 2): ?>
                                            <span class="badge badge--danger"><?php echo app('translator')->get('Canceled'); ?></span>
                                        <?php else: ?>
                                            <span class="badge badge--info"><?php echo app('translator')->get('Completed'); ?></span>
                                        <?php endif; ?>
                                    </span>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="col-xl-4 col-md-6">
                    <div class="card">
                        <div class="card-header">
                            <h5><?php echo app('translator')->get('Other Information'); ?></h5>
                        </div>
                        <div class="card-body">
                            <ul class="list-group">
                                <li class="list-group-item d-flex justify-content-between">
                                    <?php echo app('translator')->get('Total Payable'); ?>
                                    <span>
                                        <?php if($invest->period != -1): ?>
                                            <?php echo e($invest->period); ?> <?php echo app('translator')->get(' times'); ?>
                                        <?php else: ?>
                                            <?php echo app('translator')->get('Lifetime'); ?>
                                        <?php endif; ?>
                                    </span>
                                </li>
                                <li class="list-group-item d-flex justify-content-between">
                                    <?php echo app('translator')->get('Total Paid'); ?>
                                    <span><?php echo e($invest->return_rec_time); ?> <?php echo app('translator')->get(' times'); ?></span>
                                </li>
                                <li class="list-group-item d-flex justify-content-between">
                                    <?php echo app('translator')->get('Total Paid Amount'); ?>
                                    <span><?php echo e(showAmount($invest->paid)); ?></span>
                                </li>
                                <li class="list-group-item d-flex justify-content-between">
                                    <?php echo app('translator')->get('Should Pay'); ?>
                                    <span>
                                        <?php if($invest->should_pay != -1): ?>
                                            <?php echo e(showAmount($invest->should_pay)); ?>

                                        <?php else: ?>
                                            **
                                        <?php endif; ?>
                                    </span>
                                </li>
                                <li class="list-group-item d-flex justify-content-between">
                                    <?php echo app('translator')->get('Last Paid Time'); ?>
                                    <span><?php echo e(showDateTime($invest->last_time)); ?></span>
                                </li>
                                <li class="list-group-item d-flex justify-content-between">
                                    <?php echo app('translator')->get('Next Pay Time'); ?>
                                    <span><?php echo e(showDateTime($invest->next_time)); ?></span>
                                </li>

                                <li class="list-group-item d-flex justify-content-between">
                                    <?php echo app('translator')->get('Net Interest'); ?>
                                    <span><?php echo e(showAmount($invest->net_interest)); ?></span>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row mt-4">
                <div class="col-lg-12">
                    <?php if($invest->compound_times): ?>
                        <h5 class="my-2"><?php echo app('translator')->get('All Interests & Compound Investment'); ?></h5>
                    <?php else: ?>
                        <h5 class="my-2"><?php echo app('translator')->get('All Interests'); ?></h5>
                    <?php endif; ?>
                    <div class="table-responsive--md">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th><?php echo app('translator')->get('TRX'); ?></th>
                                    <th><?php echo app('translator')->get('Transacted'); ?></th>
                                    <th><?php echo app('translator')->get('Amount'); ?></th>
                                    <th><?php echo app('translator')->get('Post Balance'); ?></th>
                                    <th><?php echo app('translator')->get('Details'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trx): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td><strong><?php echo e($trx->trx); ?></strong></td>
                                        <td><?php echo e(showDateTime($trx->created_at)); ?><br><?php echo e(diffForHumans($trx->created_at)); ?></td>

                                        <td class="budget">
                                            <span class="fw-bold <?php if($trx->trx_type == '+'): ?> text--success <?php else: ?> text--danger <?php endif; ?>">
                                                <?php echo e($trx->trx_type); ?> <?php echo e(showAmount($trx->amount)); ?>

                                            </span>
                                        </td>

                                        <td class="budget">
                                            <?php echo e(showAmount($trx->post_balance)); ?>

                                        </td>

                                        <td><?php echo e(__($trx->details)); ?></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td class="text-muted text-center" colspan="100%"><?php echo e(__($emptyMessage)); ?></td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table><!-- table end -->
                    </div>
                    <?php if($transactions->hasPages()): ?>
                        <div class="custom--pagination mt-4">
                            <?php echo e(paginateLinks($transactions)); ?>

                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </section>

    <div class="modal fade" id="capitalModal">
        <div class="modal-dialog modal-dialog-centered modal-content-bg">
            <div class="modal-content">
                <div class="modal-header">
                    <strong class="modal-title text-white" id="ModalLabel">
                        <?php echo app('translator')->get('Manage Invest Capital'); ?>
                    </strong>
                    <button type="button" class="close" data-bs-dismiss="modal">
                        <i class="las la-times"></i>
                    </button>
                </div>
                <form action="<?php echo e(route('user.invest.capital.manage')); ?>" method="post">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <input type="hidden" name="invest_id" value="<?php echo e($invest->id); ?>">
                        <div class="form-group">
                            <label><?php echo app('translator')->get('Investment Capital'); ?></label>
                            <select name="capital" class="form-control">
                                <option value="reinvest"><?php echo app('translator')->get('Reinvest'); ?></option>
                                <option value="capital_back"><?php echo app('translator')->get('Capital Back'); ?></option>
                            </select>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn--base btn-md w-100"><?php echo app('translator')->get('Submit'); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/qazilzmb/xmtrade.site/core/resources/views/templates/bit_gold/user/invest_details.blade.php ENDPATH**/ ?>