<?php
    $text = request()->routeIs('user.register') ? 'Register' : 'Login';
?>

<div class="mt-2">
    <?php if(@gs('socialite_credentials')->google->status == Status::ENABLE): ?>
        <a href="<?php echo e(route('user.social.login', 'google')); ?>" class="btn btn--base w-100 my-2"><img src="<?php echo e(asset('assets/global/images/google.svg')); ?>" alt="<?php echo app('translator')->get('image'); ?>" class="others-login-image"> <?php echo app('translator')->get("$text with Google"); ?></a>
    <?php endif; ?>

    <?php if(@gs('socialite_credentials')->facebook->status == Status::ENABLE): ?>
        <a href="<?php echo e(route('user.social.login', 'facebook')); ?>" class="btn btn--base w-100 my-2"><img src="<?php echo e(asset('assets/global/images/facebook.svg')); ?>" alt="<?php echo app('translator')->get('image'); ?>" class="others-login-image"> <?php echo app('translator')->get("$text with Facebook"); ?></a>
    <?php endif; ?>

    <?php if(@gs('socialite_credentials')->linkedin->status == Status::ENABLE): ?>
        <a href="<?php echo e(route('user.social.login', 'linkedin')); ?>" class="btn btn--base w-100 my-2"><img src="<?php echo e(asset('assets/global/images/linkedin.svg')); ?>" alt="<?php echo app('translator')->get('image'); ?>" class="others-login-image"> <?php echo app('translator')->get("$text with Linkedin"); ?></a>
    <?php endif; ?>

    <?php if(gs('metamask_login')): ?>
        <button class="btn btn--base w-100 my-2 metamaskLogin"><img src="<?php echo e(asset($activeTemplateTrue . 'images/metamask.png')); ?>" alt="<?php echo app('translator')->get('image'); ?>" class="others-login-image"> <?php echo app('translator')->get("$text with Metamask"); ?></button>
    <?php endif; ?>
</div>

<?php if(@gs('socialite_credentials')->linkedin->status || @gs('socialite_credentials')->facebook->status == Status::ENABLE || @gs('socialite_credentials')->google->status == Status::ENABLE || gs('metamask_login')): ?>
    <div class="text-center">
        <span><?php echo app('translator')->get('OR'); ?></span>
    </div>
<?php endif; ?>

<?php $__env->startPush('style'); ?>
    <style>
        .social-login-btn {
            border: 1px solid #cbc4c4;
        }

        .others-login-image {
            width: 22px;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php if(gs('metamask_login')): ?>
    <?php $__env->startPush('script-lib'); ?>
        <script src="<?php echo e(asset('assets/global/js/web3.min.js')); ?>"></script>
    <?php $__env->stopPush(); ?>

    <?php $__env->startPush('script'); ?>
        <script>
            var account = null;
            var signature = null;
            var message = 'Sign In';
            var token = null;
            $('.metamaskLogin').on('click', async () => {
                // detect wallet
                if (!window.ethereum) {
                    notify('error', 'MetaMask not detected. Please install MetaMask first.');
                    return;
                }

                // get wallet address
                await window.ethereum.request({
                    method: 'eth_requestAccounts'
                });
                window.web3 = new Web3(window.ethereum);
                accounts = await web3.eth.getAccounts();
                account = accounts[0];

                // get unique message
                let response = await fetch(`<?php echo e(route('user.login.metamask')); ?>`, {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    body: JSON.stringify({
                        'account': account,
                        '_token': '<?php echo e(csrf_token()); ?>'
                    })
                });
                message = (await response.json()).message;
                setTimeout(async () => {
                    // get signature
                    signature = await web3.eth.personal.sign(message, account);

                    // verify signature
                    response = await fetch(`<?php echo e(route('user.login.metamask.verify')); ?>`, {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json'
                        },
                        body: JSON.stringify({
                            'signature': signature,
                            '_token': '<?php echo e(csrf_token()); ?>'
                        })
                    });
                    response = await response.json();

                    notify(response.type, response.message);

                    // handle login
                    if (response.type == 'success') {
                        setTimeout(() => {
                            window.location.href = response.redirect_url;
                        }, 2000);
                    }
                }, 1500);

            })
        </script>
    <?php $__env->stopPush(); ?>
<?php endif; ?>
<?php /**PATH /home/qazilzmb/xmtradings.site/core/resources/views/templates/bit_gold/partials/social_login.blade.php ENDPATH**/ ?>