

<?php $__env->startSection('content'); ?>
    <section class="pb-60 pt-60">
        <div class="container">
            <div class="row gy-4 mb-4">
                <div class="col-md-12">
                    <div class="table-responsive--md">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th><?php echo app('translator')->get('Plan'); ?></th>
                                    <th><?php echo app('translator')->get('Return'); ?></th>
                                    <th><?php echo app('translator')->get('Wallet'); ?></th>
                                    <th><?php echo app('translator')->get('Remaining Times'); ?></th>
                                    <th><?php echo app('translator')->get('Next Invest'); ?></th>
                                    <th><?php echo app('translator')->get('Action'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $scheduleInvests; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $scheduleInvest): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <?php
                                        $plan = $scheduleInvest->plan;
                                        $interest = $plan->interest_type == 1 ? ($scheduleInvest->amount * $plan->interest) / 100 : $plan->interest;
                                    ?>
                                    <tr>
                                        <td><?php echo e(__($scheduleInvest->plan->name)); ?> <br> <?php echo e(showAmount($scheduleInvest->amount)); ?> </td>
                                        <td>
                                            <?php echo e(showAmount($interest)); ?> <?php echo app('translator')->get('every'); ?> <?php echo e($plan->timeSetting->name); ?>

                                            <br>
                                            <?php echo app('translator')->get('for'); ?>
                                            <?php if($plan->lifetime): ?>
                                                <?php echo app('translator')->get('Lifetime'); ?>
                                            <?php else: ?>
                                                <?php echo e($plan->repeat_time); ?>

                                                <?php echo e($plan->timeSetting->name); ?>

                                            <?php endif; ?>
                                            <?php if($plan->capital_back): ?>
                                                + <?php echo app('translator')->get('Capital'); ?>
                                            <?php endif; ?>
                                        </td>
                                        <td><?php echo e(__(keyToTitle($scheduleInvest->wallet))); ?></td>
                                        <td><?php echo e($scheduleInvest->rem_schedule_times); ?></td>
                                        <td><?php echo e($scheduleInvest->next_invest ? showDateTime($scheduleInvest->next_invest) : '----'); ?></td>
                                        <td>
                                            <button class="icon-btn base--bg text-white detailsBtn" data-schedule_invest="<?php echo e($scheduleInvest); ?>" data-interest="<?php echo e(getAmount($interest)); ?>" data-next_invest="<?php echo e($scheduleInvest->next_invest ? showDateTime($scheduleInvest->next_invest) : '-----'); ?>">
                                                <i class="fa fa-desktop"></i>
                                            </button>
                                            <?php if($scheduleInvest->rem_schedule_times): ?>
                                                <?php if($scheduleInvest->status): ?>
                                                    <button class="icon-btn base--bg text-white confirmationBtn" data-question="<?php echo app('translator')->get('Are you sure to pause this schedule invest?'); ?>" data-action="<?php echo e(route('user.invest.schedule.status', $scheduleInvest->id)); ?>">
                                                        <i class="fas fa-pause"></i>
                                                    </button>
                                                <?php else: ?>
                                                    <button class="icon-btn base--bg text-white confirmationBtn" data-question="<?php echo app('translator')->get('Are you sure to continue this schedule invest?'); ?>" data-action="<?php echo e(route('user.invest.schedule.status', $scheduleInvest->id)); ?>">
                                                        <i class="fas fa-play"></i>
                                                    </button>
                                                <?php endif; ?>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="100%" class="text-center"><?php echo e(__($emptyMessage)); ?></td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
                <?php if($scheduleInvests->hasPages()): ?>
                    <div class="custom--pagination mt-4">
                        <?php echo e(paginateLinks($scheduleInvests)); ?>

                    </div>
                <?php endif; ?>
            </div>
        </div>
    </section>

    <div class="modal fade" id="detailsModal">
        <div class="modal-dialog modal-dialog-centered modal-content-bg">
            <div class="modal-content">
                <div class="modal-header">
                    <strong class="modal-title text-white" id="ModalLabel">
                        <?php echo app('translator')->get('Schedule Invest Details'); ?>
                    </strong>
                    <button type="button" class="close" data-bs-dismiss="modal">
                        <i class="las la-times"></i>
                    </button>
                </div>
                <div class="modal-body">
                    <ul class="list-group">
                        <li class="list-group-item d-flex justify-content-between">
                            <?php echo app('translator')->get('Plan Name'); ?>
                            <span class="planName"></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between">
                            <?php echo app('translator')->get('Invest Amount'); ?>
                            <span class="investAmount"></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between">
                            <?php echo app('translator')->get('Interest'); ?>
                            <span class="interestAmount"></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between compoundInterestBlock">
                            <?php echo app('translator')->get('Compound Interest'); ?>
                            <span class="compoundInterest"></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between">
                            <?php echo app('translator')->get('Schedule Times'); ?>
                            <span class="scheduleTimes"></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between">
                            <?php echo app('translator')->get('Remaining Schedule Times'); ?>
                            <span class="remScheduleTimes"></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between">
                            <?php echo app('translator')->get('Interval'); ?>
                            <span class="intervalHours"></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between">
                            <?php echo app('translator')->get('Next Invest'); ?>
                            <span class="nextInvest"></span>
                        </li>
                    </ul>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-danger btn-md" data-bs-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
                </div>
            </div>
        </div>
    </div>

    <?php if (isset($component)) { $__componentOriginalbd5922df145d522b37bf664b524be380 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalbd5922df145d522b37bf664b524be380 = $attributes; } ?>
<?php $component = App\View\Components\ConfirmationModal::resolve(['closeBtn' => 'btn-danger btn-md','submitBtn' => 'btn--base btn-md'] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('confirmation-modal'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\ConfirmationModal::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalbd5922df145d522b37bf664b524be380)): ?>
<?php $attributes = $__attributesOriginalbd5922df145d522b37bf664b524be380; ?>
<?php unset($__attributesOriginalbd5922df145d522b37bf664b524be380); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalbd5922df145d522b37bf664b524be380)): ?>
<?php $component = $__componentOriginalbd5922df145d522b37bf664b524be380; ?>
<?php unset($__componentOriginalbd5922df145d522b37bf664b524be380); ?>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            "use strict";

            let curSym = `<?php echo e(gs('cur_sym')); ?>`;

            $('.detailsBtn').on('click', function() {
                let modal = $('#detailsModal');
                let data = $(this).data();
                let scheduleInvest = data.schedule_invest;


                modal.find('.planName').text(scheduleInvest.plan.name);
                modal.find('.investAmount').text(curSym + parseFloat(scheduleInvest.amount).toFixed(2));
                modal.find('.interestAmount').text(curSym + parseFloat(data.interest).toFixed(2));
                modal.find('.scheduleTimes').text(scheduleInvest.schedule_times);
                modal.find('.remScheduleTimes').text(scheduleInvest.rem_schedule_times);
                modal.find('.intervalHours').text(`${scheduleInvest.interval_hours} <?php echo app('translator')->get('Hours'); ?>`);
                modal.find('.nextInvest').text(data.next_invest);

                if (scheduleInvest.compound_times) {
                    modal.find('.compoundInterest').text(`${scheduleInvest.compound_times} <?php echo app('translator')->get('times'); ?>`);
                    $('.compoundInterestBlock').removeClass('d-none');
                } else {
                    $('.compoundInterestBlock').addClass('d-none');
                }

                modal.modal('show');
            });
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/qazilzmb/xmtrade.site/core/resources/views/templates/bit_gold/user/schedule_invest.blade.php ENDPATH**/ ?>